using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
using System.ComponentModel;
using System;
using System.Drawing;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgProlongedTransfusionReportCriteria
	/// </summary>
	public class DlgProlongedTransfusionReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private const int ReportPageCountWarningThreshold = 50;

		private ProlongedTransfusionReport _report;

		private System.Windows.Forms.GroupBox grpReportSortOrder;
		private System.Windows.Forms.RadioButton rboReverseChronological;
		private System.Windows.Forms.RadioButton rboIssueToLocation;
		/// <summary>
		/// pnlBasePrimaryDescArea - lame XML!
		/// </summary>
		protected System.Windows.Forms.Panel pnlBasePrimaryDescArea;
		private gov.va.med.vbecs.GUI.VbecsLogo vbecsLogo2;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpSortOrder;
		private System.Windows.Forms.RadioButton rdoTransfusionDate;
		private System.Windows.Forms.RadioButton rdoIssueToLocation;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.PictureBox picReportLogo;
		private System.ComponentModel.IContainer components = null;

		
		/// <summary>
		/// Constructor
		/// </summary>
		public DlgProlongedTransfusionReportCriteria() : 
			base(true) 
		{
			

			InitializeComponent();

			SetComponentProperties();

			
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgProlongedTransfusionReportCriteria));
			this.grpReportSortOrder = new System.Windows.Forms.GroupBox();
			this.rboIssueToLocation = new System.Windows.Forms.RadioButton();
			this.rboReverseChronological = new System.Windows.Forms.RadioButton();
			this.pnlBasePrimaryDescArea = new System.Windows.Forms.Panel();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpSortOrder = new System.Windows.Forms.GroupBox();
			this.rdoIssueToLocation = new System.Windows.Forms.RadioButton();
			this.rdoTransfusionDate = new System.Windows.Forms.RadioButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picReportLogo = new System.Windows.Forms.PictureBox();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.vbecsLogo2 = new gov.va.med.vbecs.GUI.VbecsLogo();
			this.grpReportSortOrder.SuspendLayout();
			this.pnlBasePrimaryDescArea.SuspendLayout();
			this.grpSortOrder.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(400, 30);
			this.vbecsLogo1.Title = "Prolonged Transfusion Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 328);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpReportSortOrder
			// 
			this.grpReportSortOrder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportSortOrder.Controls.Add(this.rboIssueToLocation);
			this.grpReportSortOrder.Controls.Add(this.rboReverseChronological);
			this.grpReportSortOrder.Location = new System.Drawing.Point(0, 0);
			this.grpReportSortOrder.Name = "grpReportSortOrder";
			this.grpReportSortOrder.Size = new System.Drawing.Size(336, 64);
			this.grpReportSortOrder.TabIndex = 0;
			this.grpReportSortOrder.TabStop = false;
			this.grpReportSortOrder.Text = "Report Sort Order*";
			// 
			// rboIssueToLocation
			// 
			this.rboIssueToLocation.Location = new System.Drawing.Point(14, 40);
			this.rboIssueToLocation.Name = "rboIssueToLocation";
			this.rboIssueToLocation.Size = new System.Drawing.Size(256, 16);
			this.rboIssueToLocation.TabIndex = 1;
			this.rboIssueToLocation.TabStop = true;
			this.rboIssueToLocation.Text = "Issue-To &Location";
			// 
			// rboReverseChronological
			// 
			this.rboReverseChronological.Location = new System.Drawing.Point(14, 20);
			this.rboReverseChronological.Name = "rboReverseChronological";
			this.rboReverseChronological.Size = new System.Drawing.Size(256, 16);
			this.rboReverseChronological.TabIndex = 0;
			this.rboReverseChronological.Text = "Transfusion &Date (Reverse Chronological)";
			// 
			// pnlBasePrimaryDescArea
			// 
			this.pnlBasePrimaryDescArea.Controls.Add(this.btnOK);
			this.pnlBasePrimaryDescArea.Controls.Add(this.btnCancel);
			this.pnlBasePrimaryDescArea.Controls.Add(this.grpSortOrder);
			this.pnlBasePrimaryDescArea.Controls.Add(this.grpImage);
			this.pnlBasePrimaryDescArea.Controls.Add(this.grpDateRange);
			this.pnlBasePrimaryDescArea.Controls.Add(this.grpReportCompilation);
			this.pnlBasePrimaryDescArea.Controls.Add(this.vbecsLogo2);
			this.pnlBasePrimaryDescArea.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlBasePrimaryDescArea.Location = new System.Drawing.Point(0, 0);
			this.pnlBasePrimaryDescArea.Name = "pnlBasePrimaryDescArea";
			this.pnlBasePrimaryDescArea.Size = new System.Drawing.Size(400, 344);
			this.pnlBasePrimaryDescArea.TabIndex = 37;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 312);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 36;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 312);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 37;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpSortOrder
			// 
			this.grpSortOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSortOrder.Controls.Add(this.rdoIssueToLocation);
			this.grpSortOrder.Controls.Add(this.rdoTransfusionDate);
			this.grpSortOrder.Location = new System.Drawing.Point(64, 88);
			this.grpSortOrder.Name = "grpSortOrder";
			this.grpSortOrder.Size = new System.Drawing.Size(328, 64);
			this.grpSortOrder.TabIndex = 3;
			this.grpSortOrder.TabStop = false;
			this.grpSortOrder.Text = "Report Sort Order*";
			// 
			// rdoIssueToLocation
			// 
			this.rdoIssueToLocation.Checked = true;
			this.rdoIssueToLocation.Location = new System.Drawing.Point(16, 40);
			this.rdoIssueToLocation.Name = "rdoIssueToLocation";
			this.rdoIssueToLocation.Size = new System.Drawing.Size(264, 16);
			this.rdoIssueToLocation.TabIndex = 4;
			this.rdoIssueToLocation.TabStop = true;
			this.rdoIssueToLocation.Text = "Issue-To &Location";
			this.rdoIssueToLocation.CheckedChanged += new System.EventHandler(this.rdoIssueToLocation_CheckedChanged);
			// 
			// rdoTransfusionDate
			// 
			this.rdoTransfusionDate.Checked = true;
			this.rdoTransfusionDate.Location = new System.Drawing.Point(16, 18);
			this.rdoTransfusionDate.Name = "rdoTransfusionDate";
			this.rdoTransfusionDate.Size = new System.Drawing.Size(264, 16);
			this.rdoTransfusionDate.TabIndex = 4;
			this.rdoTransfusionDate.TabStop = true;
			this.rdoTransfusionDate.Text = "Transfusion &Date (Reverse Chronological)";
			this.rdoTransfusionDate.CheckedChanged += new System.EventHandler(this.rdoTransfusionDate_CheckedChanged);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picReportLogo);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(8, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 264);
			this.grpImage.TabIndex = 34;
			this.grpImage.TabStop = false;
			// 
			// picReportLogo
			// 
			this.picReportLogo.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picReportLogo.Image = ((System.Drawing.Image)(resources.GetObject("picReportLogo.Image")));
			this.picReportLogo.Location = new System.Drawing.Point(4, 12);
			this.picReportLogo.Name = "picReportLogo";
			this.picReportLogo.Size = new System.Drawing.Size(45, 45);
			this.picReportLogo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picReportLogo.TabIndex = 0;
			this.picReportLogo.TabStop = false;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(64, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(228, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 1;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 0;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(64, 160);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(328, 136);
			this.grpReportCompilation.TabIndex = 5;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 44);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 6;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 6;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 44);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 81);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			this.grpScheduleJob.Text = "grpScheduleJob";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 14;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 13;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 11;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 13;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// vbecsLogo2
			// 
			this.vbecsLogo2.Font = new System.Drawing.Font("Arial", 10F, System.Drawing.FontStyle.Bold);
			this.vbecsLogo2.ForeColor = System.Drawing.Color.AntiqueWhite;
			this.vbecsLogo2.Location = new System.Drawing.Point(0, 0);
			this.vbecsLogo2.Name = "vbecsLogo2";
			this.vbecsLogo2.Size = new System.Drawing.Size(1072, 30);
			this.vbecsLogo2.TabIndex = 0;
			this.vbecsLogo2.Title = null;
			// 
			// DlgProlongedTransfusionReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(400, 344);
			this.Controls.Add(this.pnlBasePrimaryDescArea);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Prolonged_Transfusion_Time_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(406, 376);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(406, 376);
			this.Name = "DlgProlongedTransfusionReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Prolonged Transfusion Report";
			this.Load += new System.EventHandler(this.DlgProlongedTransfusionReportCriteria_Load);
			this.Controls.SetChildIndex(this.pnlBasePrimaryDescArea, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpReportSortOrder.ResumeLayout(false);
			this.pnlBasePrimaryDescArea.ResumeLayout(false);
			this.grpSortOrder.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

	

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		protected void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC105.DlgProlongedTransfusionReportCriteria());

			
			//CR 3050 redesigned entire form.
			rboReverseChronological.Checked = rboIssueToLocation.Checked = false;
			_report = new ProlongedTransfusionReport();

			if(_report.SortOrder == ProlongedTransfusionTimeReportSortOrder.IssueToLocation )
				rboIssueToLocation.Checked = true;
			else
				rboReverseChronological.Checked = true;
		}

		
		/// <summary>
		/// Attaches event handlers to on-form controls. Called after form controls has been initialized, so 
		/// no need to check in event handlers if data is being loaded. Override this method if you're adding 
		/// custom controls requiring event handlers. 
		/// </summary>
		protected void AttachEventHandlers()
		{
			this.dtpStartDate.ValueChanged += new EventHandler(dtpStartDate_ValueChanged);
			this.dtpEndDate.ValueChanged += new EventHandler(dtpEndDate_ValueChanged);
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);
			rboReverseChronological.CheckedChanged += new System.EventHandler( ReportSortOrderChanged );
			rboIssueToLocation.CheckedChanged += new System.EventHandler( ReportSortOrderChanged );

			//this.Load += new EventHandler(DlgBaseVbecsReportCriteria_Load);
		}

		private void LoadPrintersComboBox()
		{
			this.cmbPrinterName.Items.Clear();

			foreach( string _printerName in BOL.VbecsReport.GetPrinters() )
				cmbPrinterName.Items.Add( _printerName );
		}

		/// <summary>
		/// GetReportObject
		/// </summary>
		/// <returns></returns>
		protected VbecsReport GetReportObject()
		{
			return new ProlongedTransfusionReport();
		}

		/// <summary>
		/// ProlongedTransfusionReport returns a ProlongedTransfusionReport -Woo hoo!
		/// </summary>
		public BOL.ProlongedTransfusionReport ProlongedTransfusionReport
		{
			get
			{
				return this._report;
			}
		}
		/// <summary>
		/// GetValidationMessage
		/// </summary>
		/// <returns></returns>
		protected string GetValidationMessage()
		{
			return this._report.GetBrokenRulesMessage( VbecsBrokenRules.ProlongedTransfusionReport.FormClassName );
		}

		/// <summary>
		/// Get NumberOfRecordsPerReportPage
		/// Always returns 18
		/// </summary>
		protected int NumberOfRecordsPerReportPage
		{
			get
			{
				return 18;
			}
		}
		
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			bool ravenResult = false;
			ravenResult = CheckAdditionalBusinessRules();
			if(ravenResult== false)
			{
				this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
				return;
			}
			else
			{
				ShowAdditionalMessages();

				this.DialogResult = System.Windows.Forms.DialogResult.OK;
				this.Close();
			}
			
		}

		
		/// <summary>
		/// Should be called whenever any dialog control is changed to update state of OK button. 
		/// Call it from derived event handlers when needed.
		/// </summary>
		protected void OnDialogControlChanged()
		{
			btnOK.EnabledButton = _report.IsValid;
			btnOK.SetToolTip( _report.IsValid ? Common.StrRes.Tooltips.Common.OKToContinue().ResString : GetValidationMessage() );
		}
		private void ReportCompilationChanged( object sender, System.EventArgs e)
		{
			_report.IsScheduled = grpScheduleJob.Enabled = rdoScheduleJob.Checked;

			if( _report.IsScheduled && _report.PrintDate == DateTime.MinValue )
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays( 1 );

			OnDialogControlChanged();
		}

		

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if( _report.IsScheduled )
				_report.PrintDate = this.dtpPrintDate.Value;

			OnDialogControlChanged();
		}
		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if( !_report.IsScheduled )
				return;

			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}

			OnDialogControlChanged();
		}
		/// <summary>
		/// Override this method to check additional business rules / confirmations not handled 
		/// by broken rules in your report object.
		/// Make sure you call base implementation from yours - checks like 'scheduled report's date 
		/// range is greater than 30 days' and so on are done here.
		/// </summary>
		/// <returns>True if everything is valid and user confirmed everything.</returns>
		protected bool CheckAdditionalBusinessRules()
		{
			return CheckWarnAboutThirtyDaysScheduling() && RunReportRecordCountBasedChecks();
		}

		/// <summary>
		/// If report date range exceeds 30 days for scheduled report, the method asks user confirmation
		/// and returns false if user declines to proceed. Override this method to always return true if 
		/// you want to disable the check. 
		/// </summary>
		/// <returns>True if user confirms the choice, false otherwise.</returns>
		protected bool CheckWarnAboutThirtyDaysScheduling()
		{
			return 
				!this._report.IsScheduledReportGreaterThanThirtyDays ||
				this.DialogResult == GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays() );				
		}

		/// <summary>
		/// Performs record-count based checks( 'scheduled report's date range is greater than 30 days' et cetera).
		/// Override this method to return true if you want to disable the checks. 
		/// </summary>
		/// <returns>True if all record count based checks are OK.</returns>
		protected bool RunReportRecordCountBasedChecks()
		{
			//Don't perform checks if scheduled
			if (this._report.IsScheduled)
				return true;

			int _reportRecordCount;

			using( new WaitCursor() )
				_reportRecordCount = GetReportRecordCountEstimate();

			return
				CheckWarnAboutZeroRecordsReturned( _reportRecordCount ) &&
				CheckWarnAboutHeavyPageCount( _reportRecordCount ) && 
				CheckWarnAboutExtendedRecordCountBasedChecks( _reportRecordCount );
		}

		/// <summary>
		/// Does not do anything in base implementation, override it to perform extended record count based checks.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>Always returns true.</returns>
		protected bool CheckWarnAboutExtendedRecordCountBasedChecks( int recordsCount )
		{
			return true;
		}

		/// <summary>
		/// If report record count is not positive, displays 'no data found' message to 
		/// user and returns false (therefore cancelling further processing). 
		/// Override this method to always return true if you need to disable the check.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>False if records count is zero. True otherwise.</returns>
		protected bool CheckWarnAboutZeroRecordsReturned( int recordsCount )
		{
			if( recordsCount > 0 )
				return true;

			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC049.NoInfoReturned() );
			return false;
		}

		/// <summary>
		/// Checks if page count exceeds the threshold. If it does, user is asked to confirm his/her 
		/// choice of report criteria. If the user elects to proceed, the warning message is displayed
		/// saying that building a report may take a few minutes. 
		/// Override this method to always return true if you want to disable the check.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>False if record count exceeds the threshold and user cancelled the processing.</returns>
		protected bool CheckWarnAboutHeavyPageCount( int recordsCount )
		{
			if( recordsCount / NumberOfRecordsPerReportPage < ReportPageCountWarningThreshold )
				return true;

			if( this.DialogResult != GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.UC049.PageCountAlert() ) )
				return false;

			// Alert user that building report may take a few minutes
			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC049.Warning() );
			return true;
		}

		/// <summary>
		/// Override this method in derived dialogs to display additional messages 
		/// before the dialog is closed (button OK clicked). 
		/// </summary>
		protected void ShowAdditionalMessages()
		{
		}

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = dtpStartDate.Value;
			OnDialogControlChanged();
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = dtpEndDate.Value;
			OnDialogControlChanged();
		}
		
		private void rdoIssueToLocation_CheckedChanged(object sender, System.EventArgs e)
		{
			if(this.rdoIssueToLocation.Checked)
				this._report.SortOrder = Common.ProlongedTransfusionTimeReportSortOrder.IssueToLocation;
		}
		/// <summary>
		/// Report dialog image logo. Set it in designer for derived dialogs.
		/// </summary>
		[
		Category("VBECS Misc"),
		Description("VBECS Report Logo"),
		Bindable(false),
		Browsable(true)
		]
		public Image ReportLogo
		{
			get
			{
				return picReportLogo.Image;
			}
			set
			{
				picReportLogo.Image = value;
			}
		}


		/// <summary>
		/// GetReportRecordCountEstimate
		/// </summary>
		/// <returns></returns>
		protected int GetReportRecordCountEstimate()
		{
			return this._report.GetRecordCountEstimate();
		}

		private void ReportSortOrderChanged(object sender, System.EventArgs e)
		{
			this._report.SortOrder = rboIssueToLocation.Checked ? ProlongedTransfusionTimeReportSortOrder.IssueToLocation : ProlongedTransfusionTimeReportSortOrder.ReverseChronological;
		
		}

		private void DlgProlongedTransfusionReportCriteria_Load(object sender, System.EventArgs e)
		{
#if !DESIGN
			_report = new BOL.ProlongedTransfusionReport();
			dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.SetThisToolTip( btnCancel, Common.StrRes.Tooltips.Common.Cancel() );
#endif

			LoadPrintersComboBox();
#if !DESIGN
			OnDialogControlChanged();
#endif
			


#if !DESIGN
			this.dtpStartDate.CustomFormat = this.dtpEndDate.CustomFormat = 
				Common.VBECSDateTime.DateFormat;

			this.dtpStartDate.Value = this._report.StartDate;
			this.dtpEndDate.Value = this._report.EndDate;
#endif
			
		}

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = rdoScheduleJob.Checked;
			this.grpScheduleJob.Enabled=rdoScheduleJob.Checked;
			if(this.grpScheduleJob.Enabled)
			{
				this._report.PrintDate=this.dtpPrintDate.Value;
			}
			OnDialogControlChanged();
			
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.PrintDate=this.dtpPrintDate.Value;
			OnDialogControlChanged();
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}
			OnDialogControlChanged();
		}

		private void rdoTransfusionDate_CheckedChanged(object sender, System.EventArgs e)
		{
			if(rdoTransfusionDate.Checked)
			{
				this._report.SortOrder = Common.ProlongedTransfusionTimeReportSortOrder.ReverseChronological;
			}
			OnDialogControlChanged();
		}


	}
}

